/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.font;

import icyllis.modernui.graphics.font.FontPaint;
import icyllis.modernui.graphics.font.GraphemeMetrics;
import icyllis.modernui.graphics.font.MeasureEngine;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LayoutPieces {
    public static final int NO_PAINT_ID = -1;
    private final Key mLookupKey = new Key();
    private final Object2IntMap<FontPaint> mPaintMap = new Object2IntOpenHashMap();
    private final Object2ObjectMap<Key, GraphemeMetrics> mMetricsMap = new Object2ObjectOpenHashMap();

    public synchronized void insert(int start, int end, GraphemeMetrics piece, boolean dir, FontPaint paint) {
        int paintId = this.mPaintMap.computeIntIfAbsent((Object)paint, p -> this.mPaintMap.size());
        if (!this.mMetricsMap.containsKey((Object)this.mLookupKey.update(start, end, dir, paintId))) {
            this.mMetricsMap.put((Object)this.mLookupKey.copy(), (Object)piece);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOrCreate(@Nonnull char[] textBuf, int start, int end, @Nonnull FontPaint paint, boolean dir, int paintId, @Nonnull BiConsumer<GraphemeMetrics, FontPaint> consumer) {
        GraphemeMetrics piece;
        LayoutPieces layoutPieces = this;
        synchronized (layoutPieces) {
            piece = (GraphemeMetrics)this.mMetricsMap.get((Object)this.mLookupKey.update(start, end, dir, paintId));
        }
        if (piece == null) {
            MeasureEngine.getInstance().create(textBuf, start, end, paint, dir, consumer);
        } else {
            consumer.accept(piece, paint);
        }
    }

    public int findPaintId(@Nonnull FontPaint paint) {
        return this.mPaintMap.getOrDefault((Object)paint, -1);
    }

    private static class Key {
        private int start;
        private int end;
        private boolean dir;
        private int paintId;

        public Key() {
        }

        public Key(int start, int end, boolean dir, int paintId) {
            this.update(start, end, dir, paintId);
        }

        public Key update(int start, int end, boolean dir, int paintId) {
            this.start = start;
            this.end = end;
            this.dir = dir;
            this.paintId = paintId;
            return this;
        }

        @Nonnull
        public Key copy() {
            return new Key(this.start, this.end, this.dir, this.paintId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.start != key.start) {
                return false;
            }
            if (this.end != key.end) {
                return false;
            }
            if (this.dir != key.dir) {
                return false;
            }
            return this.paintId == key.paintId;
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.end;
            result = 31 * result + (this.dir ? 1 : 0);
            result = 31 * result + this.paintId;
            return result;
        }
    }
}

